-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    self.attSTDetect:LinkToTarget("cAttST")
    
    if not self.loaded then
		  self.active = false
	  end
	end

  
  if not self.active then
    CheckForMovement(self)
  end  
end

function CheckForMovement(self)
  p0units = self.p0:UnitsInRadiusNumber(self:GetPosition(), 2000, '*')
    
  if p0units > 10 then
    self.attSTDetect:TriggerAllTargets()
	  self.active = true
  end
end

function OnTrigger(self, source, target)
  if target == "detectSTDeact" then
    self.active = false
  end
  if target == "detectSTActive" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.loaded = true
	  self.active = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.active)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("detectSTDeact")
  self:AddTriggerTarget("detectSTActive")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("attSTDetect")
end
